#include <applications/dialog/FirmwareDialog.h>
#include <applications/dialog/HomeDialog.h>
#include <applications/dialog/SettingDialog.h>
#include <cstdio>
#include <hal/devices.h>
#include <hal/drivers/buzzer.h>
#include <applications/dialog/VoltageDialog.h>
#include <applications/dialog/FrequencyDialog.h>
#include <applications/dialog/CellConstantDialog.h>
#include <applications/dialog/CoefficientDialog.h>
#include <applications/dialog/BaudRateDialog.h>
#include <applications/dialog/AddressDialog.h>
#include <applications/dialog/ContrastDialog.h>
#include <applications/dialog/HoldTimeDialog.h>
#include <applications/dialog/SetupTimeDialog.h>

CSettingDialog SettingDialog;

struct
{
	const char caption[18];
	CDialog * const p_dialog;
}static const menu[] = {{"EXC Voltage", &VoltageDialog},
                        {"EXC Frequency", &FrequencyDialog},
                        {"T-H setup time", &SetupTimeDialog},
                        {"T-H hold time", &HoldTimeDialog},
                        {"TEMP Coefficient", &CoefficientDialog},
                        {"Cell Constant", &CellConstantDialog},
                        {"RS-485 Baud Rate", &BaudRateDialog},
                        {"RS-485 Address", &AddressDialog},
                        {"Return To Home", &HomeDialog},
                        {"LCD Contrast", &ContrastDialog},
                        {"Firmware Info", &FirmwareDialog}};

#define SIZE(a) (sizeof(a)/sizeof(a[0]))

CSettingDialog::CSettingDialog(void)
{
	first_item = 5; //Cell Constant
	selected_line = 3; //Return To Home
}

void CSettingDialog::OnCreat(void)
{
	OnDraw();
}

void CSettingDialog::OnEncoderCW(void)
{
	if (selected_line < 3)
	{
		++selected_line;
	}
	else
	{

		if (first_item < SIZE(menu) - 4)
		{
			++first_item;
		}
		else
		{
			beep(1);
		}
	}

	OnDraw();
}

void CSettingDialog::OnEncoderCCW(void)
{
	if (selected_line > 0)
	{
		--selected_line;
	}
	else
	{
		if (first_item > 0)
		{
			--first_item;
		}
		else
		{
			beep(1);
		}
	}

	OnDraw();
}

void CSettingDialog::OnButtonDown(void)
{
	p_dialog = menu[first_item + selected_line].p_dialog;
	p_dialog->OnCreat();
}

void CSettingDialog::OnDraw(void)
{
	rewind(p_lcd);
	fwrite(zeros, 128, 1, p_lcd);
	rewind(p_lcd);

	for (int y = 0; y < 4; ++y)
	{
		fseek(p_lcd, y * 16, SEEK_SET);
		fprintf(p_lcd, "%s", menu[first_item + y].caption);
	}

	fseek(p_lcd, selected_line * 16 + 64, SEEK_SET);

	fputs("\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1", p_lcd);

	fflush(p_lcd);
}
